<?php
// Application Configuration
session_start();

// Include database first to get config
require_once __DIR__ . '/database.php';

// Get app config from database
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->query("SELECT config_key, config_value FROM app_config");
    $configs = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
    define('APP_NAME', $configs['app_name'] ?? 'SumberAI');
    define('APP_DESC', $configs['app_desc'] ?? 'Peringatan Dini Kekeringan & Manajemen Air Desa');
    define('APP_LOGO', $configs['app_logo'] ?? '');
    define('APP_FAVICON', $configs['app_favicon'] ?? '');
} catch (Exception $e) {
    // Fallback if database not ready
    define('APP_NAME', 'SumberAI');
    define('APP_DESC', 'Peringatan Dini Kekeringan & Manajemen Air Desa');
    define('APP_LOGO', '');
    define('APP_FAVICON', '');
}

define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/sumberaifix');
define('BASE_PATH', __DIR__ . '/../');

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Error Reporting (set to 0 in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Paths
define('UPLOAD_PATH', BASE_PATH . 'uploads/');
define('ASSETS_PATH', BASE_PATH . 'assets/');

// Security
define('PASSWORD_MIN_LENGTH', 6);

// Database already included above

// Helper Functions
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function getUserRole() {
    return $_SESSION['user_role'] ?? null;
}

function isAdmin() {
    return getUserRole() === 'admin';
}

function redirect($url) {
    header("Location: " . $url);
    exit();
}

function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

function formatDateTime($datetime) {
    return date('d/m/Y H:i', strtotime($datetime));
}

// Permission functions
function hasPermission($permission_key) {
    $role = getUserRole();
    if (!$role) return false;
    
    // Admin has all permissions
    if ($role === 'admin') return true;
    
    try {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->prepare("SELECT is_allowed FROM role_permissions WHERE role = ? AND permission_key IN (?, 'all') ORDER BY permission_key = 'all' DESC LIMIT 1");
        $stmt->execute([$role, $permission_key]);
        $result = $stmt->fetch();
        return $result && $result['is_allowed'] == 1;
    } catch (Exception $e) {
        return false;
    }
}

function getAppLogo() {
    $logo = APP_LOGO;
    if (empty($logo)) {
        return '<i class="fas fa-tint"></i>';
    }
    return '<img src="' . htmlspecialchars($logo) . '" alt="Logo" style="max-height: 40px; max-width: 150px;">';
}

