<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $menu_id = intval($_POST['menu_id'] ?? 0);
    $menu_label = sanitize($_POST['menu_label'] ?? '');
    $icon_class = sanitize($_POST['icon_class'] ?? '');
    $icon_color = sanitize($_POST['icon_color'] ?? '#3498db');
    $urutan = intval($_POST['urutan'] ?? 0);
    
    $stmt = $db->prepare("UPDATE menu_icons SET menu_label = ?, icon_class = ?, icon_color = ?, urutan = ? WHERE id = ?");
    if ($stmt->execute([$menu_label, $icon_class, $icon_color, $urutan, $menu_id])) {
        $_SESSION['success'] = 'Menu berhasil diupdate';
    } else {
        $_SESSION['error'] = 'Gagal update menu';
    }
    
    redirect('menu_icons.php');
}

// Get all menus
$stmt = $db->query("SELECT * FROM menu_icons ORDER BY urutan");
$menus = $stmt->fetchAll();

// Popular Font Awesome icons
$popular_icons = [
    'fas fa-home', 'fas fa-chart-line', 'fas fa-map-marked-alt', 'fas fa-file-alt',
    'fas fa-truck', 'fas fa-building', 'fas fa-users', 'fas fa-bell',
    'fas fa-chart-bar', 'fas fa-cog', 'fas fa-tint', 'fas fa-water',
    'fas fa-cloud-rain', 'fas fa-thermometer-half', 'fas fa-exclamation-triangle',
    'fas fa-check-circle', 'fas fa-info-circle', 'fas fa-calendar', 'fas fa-clock'
];

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Menu Icons - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="users.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Kelola Pengguna</span>
            </a>
            <a href="desa.php" class="nav-item">
                <i class="fas fa-building"></i>
                <span>Kelola Desa</span>
            </a>
            <a href="menu_icons.php" class="nav-item active">
                <i class="fas fa-palette"></i>
                <span>Kelola Menu</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-palette"></i> Kelola Menu Icons</h1>
                <p>Ubah icon dan label menu dashboard</p>
            </div>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <div class="content-section">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Icon</th>
                            <th>Key</th>
                            <th>Label</th>
                            <th>Icon Class</th>
                            <th>Warna</th>
                            <th>Urutan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($menus as $menu): ?>
                        <tr>
                            <td>
                                <div class="menu-icon-preview" style="color: <?php echo $menu['icon_color']; ?>;">
                                    <i class="<?php echo $menu['icon_class']; ?>"></i>
                                </div>
                            </td>
                            <td><?php echo htmlspecialchars($menu['menu_key']); ?></td>
                            <td><?php echo htmlspecialchars($menu['menu_label']); ?></td>
                            <td><?php echo htmlspecialchars($menu['icon_class']); ?></td>
                            <td>
                                <span style="display: inline-block; width: 30px; height: 30px; background: <?php echo $menu['icon_color']; ?>; border-radius: 5px;"></span>
                            </td>
                            <td><?php echo $menu['urutan']; ?></td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="editMenu(<?php echo htmlspecialchars(json_encode($menu)); ?>)">
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Edit Modal -->
    <div id="editModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('editModal').style.display='none'">&times;</span>
            <h2>Edit Menu</h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="menu_id" id="menu_id">
                <div class="form-group">
                    <label>Menu Key</label>
                    <input type="text" id="menu_key" readonly>
                </div>
                <div class="form-group">
                    <label>Label Menu</label>
                    <input type="text" name="menu_label" id="menu_label" required>
                </div>
                <div class="form-group">
                    <label>Icon Class (Font Awesome)</label>
                    <input type="text" name="icon_class" id="icon_class" required placeholder="fas fa-home">
                    <small>Gunakan class Font Awesome, contoh: fas fa-home</small>
                    <div style="margin-top: 10px; display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px;">
                        <?php foreach ($popular_icons as $icon): ?>
                        <button type="button" class="btn btn-sm" onclick="selectIcon('<?php echo $icon; ?>')" style="font-size: 1.2rem;">
                            <i class="<?php echo $icon; ?>"></i>
                        </button>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="form-group">
                    <label>Warna Icon</label>
                    <input type="color" name="icon_color" id="icon_color" value="#3498db">
                </div>
                <div class="form-group">
                    <label>Urutan</label>
                    <input type="number" name="urutan" id="urutan" min="0" required>
                </div>
                <div class="form-group">
                    <label>Preview</label>
                    <div style="text-align: center; padding: 20px; background: #f5f5f5; border-radius: 10px;">
                        <div id="iconPreview" style="font-size: 3rem; color: #3498db;">
                            <i class="fas fa-home"></i>
                        </div>
                        <p id="labelPreview">Dashboard</p>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Simpan</button>
            </form>
        </div>
    </div>

    <script src="../assets/js/main.js"></script>
    <script>
    function editMenu(menu) {
        document.getElementById('editModal').style.display = 'block';
        document.getElementById('menu_id').value = menu.id;
        document.getElementById('menu_key').value = menu.menu_key;
        document.getElementById('menu_label').value = menu.menu_label;
        document.getElementById('icon_class').value = menu.icon_class;
        document.getElementById('icon_color').value = menu.icon_color;
        document.getElementById('urutan').value = menu.urutan;
        updatePreview();
    }
    
    function selectIcon(iconClass) {
        document.getElementById('icon_class').value = iconClass;
        updatePreview();
    }
    
    function updatePreview() {
        const iconClass = document.getElementById('icon_class').value;
        const iconColor = document.getElementById('icon_color').value;
        const label = document.getElementById('menu_label').value;
        
        const preview = document.getElementById('iconPreview');
        preview.innerHTML = `<i class="${iconClass}"></i>`;
        preview.style.color = iconColor;
        
        document.getElementById('labelPreview').textContent = label || 'Label';
    }
    
    document.getElementById('icon_class').addEventListener('input', updatePreview);
    document.getElementById('icon_color').addEventListener('input', updatePreview);
    document.getElementById('menu_label').addEventListener('input', updatePreview);
    
    window.onclick = function(event) {
        if (event.target == document.getElementById('editModal')) {
            document.getElementById('editModal').style.display = 'none';
        }
    }
    </script>
    <style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        overflow-y: auto;
    }
    
    .modal-content {
        background: white;
        margin: 3% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 700px;
    }
    
    .close {
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        color: #999;
    }
    
    .menu-icon-preview {
        font-size: 2rem;
    }
    </style>
</body>
</html>

