<?php
require_once '../config/config.php';

if (!isAdmin() && getUserRole() !== 'pemdes') {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'approve') {
        $id = intval($_POST['id'] ?? 0);
        
        // Get distribution info
        $stmt = $db->prepare("SELECT dt.*, dus.nama_dusun, des.nama_desa FROM distribusi_tangki dt JOIN dusun dus ON dt.dusun_id = dus.id JOIN desa des ON dus.desa_id = des.id WHERE dt.id = ?");
        $stmt->execute([$id]);
        $dist = $stmt->fetch();
        
        $stmt = $db->prepare("UPDATE distribusi_tangki SET status = 'disetujui', approved_by = ?, approved_at = NOW() WHERE id = ?");
        if ($stmt->execute([$_SESSION['user_id'], $id])) {
            // Send notification to warga in this dusun
            $stmt = $db->prepare("INSERT INTO notifikasi (user_id, judul, pesan, tipe) 
                                  SELECT u.id, 'Pengiriman Air Disetujui', 
                                  CONCAT('Pengiriman air ke ', ?, ' - ', ?, ' pada ', DATE_FORMAT(?, '%d/%m/%Y'), ' telah disetujui. Air akan segera disiapkan.'), 
                                  'success'
                                  FROM users u 
                                  JOIN laporan_warga lw ON u.id = lw.user_id 
                                  WHERE lw.dusun_id = ? AND u.role = 'warga'");
            $stmt->execute([$dist['nama_desa'], $dist['nama_dusun'], $dist['tanggal_jadwal'], $dist['dusun_id']]);
            
            $_SESSION['success'] = 'Distribusi disetujui';
        } else {
            $_SESSION['error'] = 'Gagal menyetujui';
        }
    } elseif ($action === 'reject') {
        $id = intval($_POST['id'] ?? 0);
        $alasan = sanitize($_POST['alasan_reject'] ?? '');
        
        if (empty($alasan)) {
            $_SESSION['error'] = 'Alasan penolakan harus diisi';
        } else {
            // Get distribution info
            $stmt = $db->prepare("SELECT dt.*, dus.nama_dusun, des.nama_desa FROM distribusi_tangki dt JOIN dusun dus ON dt.dusun_id = dus.id JOIN desa des ON dus.desa_id = des.id WHERE dt.id = ?");
            $stmt->execute([$id]);
            $dist = $stmt->fetch();
            
            $stmt = $db->prepare("UPDATE distribusi_tangki SET status = 'ditolak', alasan_reject = ?, approved_by = ?, approved_at = NOW() WHERE id = ?");
            if ($stmt->execute([$alasan, $_SESSION['user_id'], $id])) {
                // Send notification to warga
                $stmt = $db->prepare("INSERT INTO notifikasi (user_id, judul, pesan, tipe) 
                                      SELECT u.id, 'Pengiriman Air Ditolak', 
                                      CONCAT('Pengiriman air ke ', ?, ' - ', ?, ' ditolak. Alasan: ', ?), 
                                      'danger'
                                      FROM users u 
                                      JOIN laporan_warga lw ON u.id = lw.user_id 
                                      WHERE lw.dusun_id = ? AND u.role = 'warga'");
                $stmt->execute([$dist['nama_desa'], $dist['nama_dusun'], $alasan, $dist['dusun_id']]);
                
                $_SESSION['success'] = 'Distribusi ditolak';
            } else {
                $_SESSION['error'] = 'Gagal menolak';
            }
        }
    } elseif ($action === 'update_status') {
        $id = intval($_POST['id'] ?? 0);
        $status = sanitize($_POST['status'] ?? '');
        
        // Get distribution info
        $stmt = $db->prepare("SELECT dt.*, dus.nama_dusun, des.nama_desa FROM distribusi_tangki dt JOIN dusun dus ON dt.dusun_id = dus.id JOIN desa des ON dus.desa_id = des.id WHERE dt.id = ?");
        $stmt->execute([$id]);
        $dist = $stmt->fetch();
        
        $stmt = $db->prepare("UPDATE distribusi_tangki SET status = ? WHERE id = ?");
        if ($stmt->execute([$status, $id])) {
            // Send notification based on status
            $judul = '';
            $pesan = '';
            $tipe = 'info';
            
            if ($status === 'penyiapan') {
                $judul = 'Air Sedang Disiapkan';
                $pesan = "Pengiriman air ke {$dist['nama_desa']} - {$dist['nama_dusun']} sedang dalam proses penyiapan. Air akan segera dikirim.";
            } elseif ($status === 'dalam_perjalanan') {
                $judul = 'Air Sedang Dikirim';
                $pesan = "Pengiriman air ke {$dist['nama_desa']} - {$dist['nama_dusun']} sedang dalam perjalanan. Harap siapkan tempat penampungan.";
                $tipe = 'warning';
            } elseif ($status === 'selesai') {
                $judul = 'Pengiriman Air Selesai';
                $pesan = "Pengiriman air ke {$dist['nama_desa']} - {$dist['nama_dusun']} telah selesai. Air sudah sampai di lokasi.";
                $tipe = 'success';
            }
            
            if (!empty($judul)) {
                $stmt = $db->prepare("INSERT INTO notifikasi (user_id, judul, pesan, tipe) 
                                      SELECT u.id, ?, ?, ?
                                      FROM users u 
                                      JOIN laporan_warga lw ON u.id = lw.user_id 
                                      WHERE lw.dusun_id = ? AND u.role = 'warga'");
                $stmt->execute([$judul, $pesan, $tipe, $dist['dusun_id']]);
            }
            
            $_SESSION['success'] = 'Status berhasil diupdate';
        } else {
            $_SESSION['error'] = 'Gagal update status';
        }
    }
    
    redirect('distribusi.php');
}

// Get all distributions
$stmt = $db->query("SELECT dt.*, dus.nama_dusun, des.nama_desa, u.nama_lengkap as petugas, 
                    u2.nama_lengkap as approved_by_name
                    FROM distribusi_tangki dt
                    JOIN dusun dus ON dt.dusun_id = dus.id
                    JOIN desa des ON dus.desa_id = des.id
                    LEFT JOIN users u ON dt.petugas_id = u.id
                    LEFT JOIN users u2 ON dt.approved_by = u2.id
                    ORDER BY dt.created_at DESC");
$distributions = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Distribusi - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="users.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Kelola Pengguna</span>
            </a>
            <a href="desa.php" class="nav-item">
                <i class="fas fa-building"></i>
                <span>Kelola Desa</span>
            </a>
            <a href="distribusi.php" class="nav-item active">
                <i class="fas fa-truck"></i>
                <span>Manajemen Distribusi</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-truck"></i> Manajemen Distribusi Air</h1>
                <p>Approve/Reject dan kelola distribusi air tangki</p>
            </div>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <div class="content-section">
            <h2>Daftar Distribusi</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Desa/Dusun</th>
                            <th>Volume</th>
                            <th>Petugas</th>
                            <th>Status</th>
                            <th>Disetujui Oleh</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($distributions)): ?>
                        <tr>
                            <td colspan="7" class="text-center">Belum ada distribusi</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($distributions as $dist): ?>
                        <tr>
                            <td><?php echo formatDate($dist['tanggal_jadwal']); ?></td>
                            <td><?php echo htmlspecialchars($dist['nama_desa']); ?> - <?php echo htmlspecialchars($dist['nama_dusun']); ?></td>
                            <td><?php echo number_format($dist['volume_liter'] ?? 0); ?> L</td>
                            <td><?php echo htmlspecialchars($dist['petugas'] ?? '-'); ?></td>
                            <td>
                                <?php
                                $status_class = 'info';
                                $status_text = ucfirst(str_replace('_', ' ', $dist['status']));
                                if ($dist['status'] === 'disetujui') $status_class = 'success';
                                elseif ($dist['status'] === 'ditolak') $status_class = 'danger';
                                elseif ($dist['status'] === 'selesai') $status_class = 'success';
                                elseif ($dist['status'] === 'menunggu_approval') $status_class = 'warning';
                                ?>
                                <span class="badge badge-<?php echo $status_class; ?>">
                                    <?php echo $status_text; ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($dist['approved_by_name'] ?? '-'); ?></td>
                            <td>
                                <?php if ($dist['status'] === 'menunggu_approval'): ?>
                                <button class="btn btn-sm btn-success" onclick="approveDistribusi(<?php echo $dist['id']; ?>)">
                                    <i class="fas fa-check"></i> Setujui
                                </button>
                                <button class="btn btn-sm btn-danger" onclick="rejectDistribusi(<?php echo $dist['id']; ?>)">
                                    <i class="fas fa-times"></i> Tolak
                                </button>
                                <?php elseif ($dist['status'] === 'disetujui'): ?>
                                <button class="btn btn-sm btn-primary" onclick="updateStatus(<?php echo $dist['id']; ?>, 'penyiapan')">
                                    <i class="fas fa-cog"></i> Penyiapan
                                </button>
                                <?php elseif ($dist['status'] === 'penyiapan'): ?>
                                <button class="btn btn-sm btn-warning" onclick="updateStatus(<?php echo $dist['id']; ?>, 'dalam_perjalanan')">
                                    <i class="fas fa-truck"></i> Mulai Pengiriman
                                </button>
                                <?php elseif ($dist['status'] === 'dalam_perjalanan'): ?>
                                <button class="btn btn-sm btn-success" onclick="updateStatus(<?php echo $dist['id']; ?>, 'selesai')">
                                    <i class="fas fa-check-circle"></i> Selesai
                                </button>
                                <?php endif; ?>
                                <a href="distribusi_detail.php?id=<?php echo $dist['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Approve Modal -->
    <div id="approveModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('approveModal').style.display='none'">&times;</span>
            <h2>Setujui Distribusi</h2>
            <p>Apakah Anda yakin ingin menyetujui distribusi ini?</p>
            <form method="POST" style="margin-top: 20px;">
                <input type="hidden" name="action" value="approve">
                <input type="hidden" name="id" id="approve_id">
                <button type="submit" class="btn btn-success btn-block">Ya, Setujui</button>
                <button type="button" class="btn btn-secondary btn-block" onclick="document.getElementById('approveModal').style.display='none'">Batal</button>
            </form>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('rejectModal').style.display='none'">&times;</span>
            <h2>Tolak Distribusi</h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="action" value="reject">
                <input type="hidden" name="id" id="reject_id">
                <div class="form-group">
                    <label>Alasan Penolakan <span style="color: red;">*</span></label>
                    <textarea name="alasan_reject" rows="4" required placeholder="Jelaskan alasan penolakan..."></textarea>
                </div>
                <button type="submit" class="btn btn-danger btn-block">Tolak</button>
                <button type="button" class="btn btn-secondary btn-block" onclick="document.getElementById('rejectModal').style.display='none'">Batal</button>
            </form>
        </div>
    </div>

    <script src="../assets/js/main.js"></script>
    <script>
    function approveDistribusi(id) {
        document.getElementById('approveModal').style.display = 'block';
        document.getElementById('approve_id').value = id;
    }
    
    function rejectDistribusi(id) {
        document.getElementById('rejectModal').style.display = 'block';
        document.getElementById('reject_id').value = id;
    }
    
    function updateStatus(id, status) {
        if (confirm('Update status distribusi?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="action" value="update_status">
                <input type="hidden" name="id" value="${id}">
                <input type="hidden" name="status" value="${status}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    }
    
    window.onclick = function(event) {
        const modals = document.querySelectorAll('.modal');
        modals.forEach(modal => {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        });
    }
    </script>
    <style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        overflow-y: auto;
    }
    
    .modal-content {
        background: white;
        margin: 5% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 600px;
    }
    
    .close {
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        color: #999;
    }
    </style>
</body>
</html>

