<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$id = intval($_GET['id'] ?? 0);
if (!$id) {
    redirect('index.php');
}

$db = Database::getInstance()->getConnection();

$stmt = $db->prepare("SELECT l.*, u.nama_lengkap, u.email, u.no_hp, d.nama_dusun, d.rt, d.rw, d.alamat as alamat_dusun, des.nama_desa 
                      FROM laporan_warga l 
                      JOIN users u ON l.user_id = u.id 
                      JOIN dusun d ON l.dusun_id = d.id 
                      JOIN desa des ON d.desa_id = des.id 
                      WHERE l.id = ?");
$stmt->execute([$id]);
$report = $stmt->fetch();

if (!$report) {
    redirect('index.php');
}

// Check permission
if (!isAdmin() && getUserRole() !== 'pemdes' && $report['user_id'] != $_SESSION['user_id']) {
    redirect('index.php');
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Laporan - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php if ($report['latitude'] && $report['longitude']): ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <?php endif; ?>
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-file-alt"></i>
                <span>Laporan</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-file-alt"></i> Detail Laporan</h1>
                <p>Informasi lengkap laporan warga</p>
            </div>
            <a href="index.php" class="btn btn-primary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </header>

        <div class="content-section">
            <div class="form-row">
                <div class="form-group">
                    <label>Pelapor</label>
                    <input type="text" value="<?php echo htmlspecialchars($report['nama_lengkap']); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Tanggal Laporan</label>
                    <input type="text" value="<?php echo formatDate($report['tanggal']); ?>" readonly>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Desa</label>
                    <input type="text" value="<?php echo htmlspecialchars($report['nama_desa']); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Dusun</label>
                    <input type="text" value="<?php echo htmlspecialchars($report['nama_dusun']); ?>" readonly>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Sumber Air</label>
                    <input type="text" value="<?php echo ucfirst($report['sumber_air'] ?? 'lainnya'); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Jenis Laporan</label>
                    <input type="text" value="<?php echo ucfirst(str_replace('_', ' ', $report['jenis_laporan'])); ?>" readonly>
                </div>
            </div>
            
            <div class="form-group">
                <label>Status</label>
                <div>
                    <span class="badge badge-<?php echo $report['status'] === 'verified' ? 'success' : ($report['status'] === 'rejected' ? 'danger' : 'warning'); ?>" style="font-size: 1.1rem; padding: 10px 20px;">
                        <?php echo strtoupper($report['status']); ?>
                    </span>
                </div>
            </div>
            
            <div class="form-group">
                <label>Deskripsi</label>
                <textarea readonly rows="5"><?php echo htmlspecialchars($report['deskripsi']); ?></textarea>
            </div>
            
            <?php if (!empty($report['foto'])): ?>
            <div class="form-group">
                <label>Foto</label>
                <div style="text-align: center;">
                    <img src="../<?php echo htmlspecialchars($report['foto']); ?>" alt="Foto Laporan" style="max-width: 100%; max-height: 500px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.2);">
                    <br>
                    <a href="../<?php echo htmlspecialchars($report['foto']); ?>" target="_blank" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-expand"></i> Lihat Full Size
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if ($report['latitude'] && $report['longitude']): ?>
            <div class="form-group">
                <label>Lokasi (Koordinat GPS)</label>
                <div class="form-row">
                    <div class="form-group">
                        <label>Latitude</label>
                        <input type="text" value="<?php echo number_format($report['latitude'], 6); ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label>Longitude</label>
                        <input type="text" value="<?php echo number_format($report['longitude'], 6); ?>" readonly>
                    </div>
                </div>
                <div id="map" style="height: 400px; margin-top: 15px;"></div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <?php if ($report['latitude'] && $report['longitude']): ?>
    <script>
    const map = L.map('map').setView([<?php echo $report['latitude']; ?>, <?php echo $report['longitude']; ?>], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    L.marker([<?php echo $report['latitude']; ?>, <?php echo $report['longitude']; ?>])
        .addTo(map)
        .bindPopup('<?php echo htmlspecialchars($report['nama_dusun']); ?><br>Lokasi Laporan')
        .openPopup();
    </script>
    <?php endif; ?>

    <script src="../assets/js/main.js"></script>
</body>
</html>

