<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$db = Database::getInstance()->getConnection();

// Get predictions
$stmt = $db->query("SELECT p.*, d.nama_dusun, d.rt, d.rw, des.nama_desa 
                    FROM prediksi_kekeringan p 
                    JOIN dusun d ON p.dusun_id = d.id 
                    JOIN desa des ON d.desa_id = des.id 
                    WHERE p.tanggal_prediksi >= CURDATE() 
                    ORDER BY p.skor_risiko DESC, p.tanggal_prediksi DESC");
$predictions = $stmt->fetchAll();

// Get statistics
$stats = [];
$stats['total'] = count($predictions);
$stats['kering'] = count(array_filter($predictions, fn($p) => $p['tingkat_risiko'] === 'kering'));
$stats['waspada'] = count(array_filter($predictions, fn($p) => $p['tingkat_risiko'] === 'waspada'));
$stats['aman'] = count(array_filter($predictions, fn($p) => $p['tingkat_risiko'] === 'aman'));

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prediksi Kekeringan - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-chart-line"></i>
                <span>Prediksi</span>
            </a>
            <a href="../peta/index.php" class="nav-item">
                <i class="fas fa-map-marked-alt"></i>
                <span>Peta</span>
            </a>
            <a href="../laporan/index.php" class="nav-item">
                <i class="fas fa-file-alt"></i>
                <span>Laporan</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-chart-line"></i> Prediksi Kekeringan</h1>
                <p>Prediksi risiko kekeringan 7 hari ke depan</p>
            </div>
            <?php if (isAdmin()): ?>
            <button class="btn btn-primary" onclick="generatePrediction()">
                <i class="fas fa-sync"></i> Generate Prediksi
            </button>
            <?php endif; ?>
        </header>

        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon" style="background: #e74c3c;">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['kering']; ?></h3>
                    <p>Zona Kering</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: #f39c12;">
                    <i class="fas fa-eye"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['waspada']; ?></h3>
                    <p>Zona Waspada</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: #2ecc71;">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['aman']; ?></h3>
                    <p>Zona Aman</p>
                </div>
            </div>
        </div>

        <!-- Predictions Table -->
        <div class="content-section">
            <h2>Daftar Prediksi</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Desa</th>
                            <th>Dusun</th>
                            <th>RT/RW</th>
                            <th>Tanggal Prediksi</th>
                            <th>Tingkat Risiko</th>
                            <th>Skor Risiko</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($predictions)): ?>
                        <tr>
                            <td colspan="7" class="text-center">Belum ada prediksi. <?php if (isAdmin()): ?>Klik "Generate Prediksi" untuk membuat prediksi baru.<?php endif; ?></td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($predictions as $pred): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($pred['nama_desa']); ?></td>
                            <td><?php echo htmlspecialchars($pred['nama_dusun']); ?></td>
                            <td><?php echo htmlspecialchars($pred['rt'] ?? '-'); ?>/<?php echo htmlspecialchars($pred['rw'] ?? '-'); ?></td>
                            <td><?php echo formatDate($pred['tanggal_prediksi']); ?></td>
                            <td>
                                <span class="badge badge-<?php echo $pred['tingkat_risiko'] === 'kering' ? 'danger' : ($pred['tingkat_risiko'] === 'waspada' ? 'warning' : 'success'); ?>">
                                    <?php echo ucfirst($pred['tingkat_risiko']); ?>
                                </span>
                            </td>
                            <td><?php echo number_format($pred['skor_risiko'], 2); ?></td>
                            <td>
                                <a href="detail.php?id=<?php echo $pred['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
    <script>
    function generatePrediction() {
        if (confirm('Generate prediksi baru untuk semua dusun?')) {
            window.location.href = 'generate.php';
        }
    }
    </script>
</body>
</html>

