<?php
require_once '../config/config.php';

if (getUserRole() !== 'warga') {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Get distributions for my dusun
$stmt = $db->prepare("SELECT dt.*, dus.nama_dusun, des.nama_desa, u.nama_lengkap as petugas, d.nama_depo
                      FROM distribusi_tangki dt
                      JOIN dusun dus ON dt.dusun_id = dus.id
                      JOIN desa des ON dus.desa_id = des.id
                      LEFT JOIN users u ON dt.petugas_id = u.id
                      LEFT JOIN depo_pengiriman d ON dt.depo_id = d.id
                      WHERE dus.id IN (
                          SELECT dusun_id FROM laporan_warga WHERE user_id = ?
                      ) OR dt.status IN ('disetujui', 'penyiapan', 'dalam_perjalanan', 'selesai')
                      ORDER BY dt.tanggal_jadwal DESC, dt.created_at DESC");
$stmt->execute([$_SESSION['user_id']]);
$distributions = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Pengiriman - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-truck"></i> Status Pengiriman Air</h1>
                <p>Informasi pengiriman air ke daerah Anda</p>
            </div>
        </header>

        <div class="content-section">
            <h2>Daftar Pengiriman</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Desa/Dusun</th>
                            <th>Volume</th>
                            <th>Petugas</th>
                            <th>Status</th>
                            <th>Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($distributions)): ?>
                        <tr>
                            <td colspan="6" class="text-center">Belum ada pengiriman</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($distributions as $dist): ?>
                        <tr>
                            <td><?php echo formatDate($dist['tanggal_jadwal']); ?></td>
                            <td><?php echo htmlspecialchars($dist['nama_desa']); ?> - <?php echo htmlspecialchars($dist['nama_dusun']); ?></td>
                            <td><?php echo number_format($dist['volume_liter'] ?? 0); ?> L</td>
                            <td><?php echo htmlspecialchars($dist['petugas'] ?? '-'); ?></td>
                            <td>
                                <?php
                                $status_class = 'info';
                                $status_text = ucfirst(str_replace('_', ' ', $dist['status']));
                                if ($dist['status'] === 'selesai') {
                                    $status_class = 'success';
                                    $status_text = 'Selesai';
                                } elseif ($dist['status'] === 'dalam_perjalanan') {
                                    $status_class = 'warning';
                                    $status_text = 'Dalam Perjalanan';
                                } elseif ($dist['status'] === 'penyiapan') {
                                    $status_class = 'warning';
                                    $status_text = 'Penyiapan';
                                } elseif ($dist['status'] === 'disetujui') {
                                    $status_class = 'success';
                                    $status_text = 'Disetujui';
                                } elseif ($dist['status'] === 'ditolak') {
                                    $status_class = 'danger';
                                    $status_text = 'Ditolak';
                                }
                                ?>
                                <span class="badge badge-<?php echo $status_class; ?>">
                                    <?php echo $status_text; ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($dist['status'] === 'dalam_perjalanan'): ?>
                                <span class="badge badge-info">
                                    <i class="fas fa-truck-moving"></i> Air sedang dalam perjalanan
                                </span>
                                <?php elseif ($dist['status'] === 'penyiapan'): ?>
                                <span class="badge badge-warning">
                                    <i class="fas fa-cog"></i> Air sedang disiapkan
                                </span>
                                <?php elseif ($dist['status'] === 'selesai'): ?>
                                <span class="badge badge-success">
                                    <i class="fas fa-check-circle"></i> Pengiriman selesai
                                </span>
                                <?php elseif ($dist['status'] === 'disetujui'): ?>
                                <span class="badge badge-success">
                                    <i class="fas fa-check"></i> Pengiriman disetujui
                                </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
</body>
</html>

