<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$db = Database::getInstance()->getConnection();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'create') {
        $dusun_id = intval($_POST['dusun_id'] ?? 0);
        $tanggal_jadwal = sanitize($_POST['tanggal_jadwal'] ?? '');
        $volume_liter = intval($_POST['volume_liter'] ?? 0);
        $petugas_id = intval($_POST['petugas_id'] ?? 0);
        $catatan = sanitize($_POST['catatan'] ?? '');
        
        if ($dusun_id > 0 && !empty($tanggal_jadwal)) {
            $stmt = $db->prepare("INSERT INTO distribusi_tangki (dusun_id, tanggal_jadwal, volume_liter, catatan, petugas_id, status) VALUES (?, ?, ?, ?, ?, 'menunggu_approval')");
            if ($stmt->execute([$dusun_id, $tanggal_jadwal, $volume_liter, $catatan, $petugas_id])) {
                $_SESSION['success'] = 'Jadwal distribusi berhasil dibuat. Menunggu approval admin/pemdes.';
            } else {
                $_SESSION['error'] = 'Gagal membuat jadwal';
            }
        } else {
            $_SESSION['error'] = 'Data tidak lengkap';
        }
    } elseif ($action === 'update_status') {
        $id = intval($_POST['id'] ?? 0);
        $status = sanitize($_POST['status'] ?? '');
        
        $stmt = $db->prepare("UPDATE distribusi_tangki SET status = ? WHERE id = ?");
        if ($stmt->execute([$status, $id])) {
            $_SESSION['success'] = 'Status berhasil diupdate';
        } else {
            $_SESSION['error'] = 'Gagal update status';
        }
    }
    
    redirect('index.php');
}

// Get AI recommended schedule
$stmt = $db->query("SELECT d.*, dus.nama_dusun, des.nama_desa, p.tingkat_risiko, p.skor_risiko
                    FROM dusun d
                    JOIN desa des ON d.desa_id = des.id
                    LEFT JOIN prediksi_kekeringan p ON d.id = p.dusun_id AND p.tanggal_prediksi >= CURDATE()
                    WHERE p.tingkat_risiko IN ('kering', 'waspada')
                    ORDER BY p.skor_risiko DESC, p.tingkat_risiko DESC
                    LIMIT 10");
$recommended = $stmt->fetchAll();

// Get scheduled distributions
$where = "1=1";
if (!isAdmin() && getUserRole() !== 'pemdes') {
    $where = "dt.petugas_id = " . intval($_SESSION['user_id']);
}

$stmt = $db->query("SELECT dt.*, dus.nama_dusun, des.nama_desa, u.nama_lengkap as petugas
                    FROM distribusi_tangki dt
                    JOIN dusun dus ON dt.dusun_id = dus.id
                    JOIN desa des ON dus.desa_id = des.id
                    LEFT JOIN users u ON dt.petugas_id = u.id
                    WHERE $where
                    ORDER BY dt.tanggal_jadwal DESC, dt.created_at DESC");
$distributions = $stmt->fetchAll();

// Get petugas list for form
$stmt = $db->query("SELECT * FROM users WHERE role = 'petugas_tangki' AND status = 'active' ORDER BY nama_lengkap");
$petugas_list = $stmt->fetchAll();

// Get dusun list
$stmt = $db->query("SELECT d.*, des.nama_desa FROM dusun d JOIN desa des ON d.desa_id = des.id ORDER BY des.nama_desa, d.nama_dusun");
$dusun_list = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Distribusi Tangki - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-truck"></i>
                <span>Distribusi</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-truck"></i> Distribusi Tangki Air</h1>
                <p>Manajemen penjadwalan distribusi air</p>
            </div>
            <button class="btn btn-primary" onclick="document.getElementById('createModal').style.display='block'">
                <i class="fas fa-plus"></i> Buat Jadwal
            </button>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <!-- AI Recommendations -->
        <?php if (!empty($recommended)): ?>
        <div class="content-section">
            <h2><i class="fas fa-brain"></i> Rekomendasi AI (Prioritas Tinggi)</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Desa/Dusun</th>
                            <th>Tingkat Risiko</th>
                            <th>Skor</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recommended as $rec): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($rec['nama_desa']); ?> - <?php echo htmlspecialchars($rec['nama_dusun']); ?></td>
                            <td>
                                <span class="badge badge-<?php echo $rec['tingkat_risiko'] === 'kering' ? 'danger' : 'warning'; ?>">
                                    <?php echo ucfirst($rec['tingkat_risiko']); ?>
                                </span>
                            </td>
                            <td><?php echo number_format($rec['skor_risiko'], 2); ?></td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="quickSchedule(<?php echo $rec['id']; ?>, '<?php echo htmlspecialchars($rec['nama_dusun']); ?>')">
                                    <i class="fas fa-calendar-plus"></i> Jadwalkan
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Scheduled Distributions -->
        <div class="content-section">
            <h2>Jadwal Distribusi</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Desa/Dusun</th>
                            <th>Volume (Liter)</th>
                            <th>Petugas</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($distributions)): ?>
                        <tr>
                            <td colspan="6" class="text-center">Belum ada jadwal distribusi</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($distributions as $dist): ?>
                        <tr>
                            <td><?php echo formatDate($dist['tanggal_jadwal']); ?></td>
                            <td><?php echo htmlspecialchars($dist['nama_desa']); ?> - <?php echo htmlspecialchars($dist['nama_dusun']); ?></td>
                            <td><?php echo number_format($dist['volume_liter'] ?? 0); ?></td>
                            <td><?php echo htmlspecialchars($dist['petugas'] ?? '-'); ?></td>
                            <td>
                                <?php
                                $status_class = 'info';
                                $status_text = ucfirst(str_replace('_', ' ', $dist['status']));
                                if ($dist['status'] === 'disetujui' || $dist['status'] === 'selesai') $status_class = 'success';
                                elseif ($dist['status'] === 'ditolak' || $dist['status'] === 'dibatalkan') $status_class = 'danger';
                                elseif ($dist['status'] === 'menunggu_approval') $status_class = 'warning';
                                elseif ($dist['status'] === 'dalam_perjalanan') $status_class = 'warning';
                                ?>
                                <span class="badge badge-<?php echo $status_class; ?>">
                                    <?php echo $status_text; ?>
                                </span>
                            </td>
                            <td>
                                <a href="<?php echo (isAdmin() || getUserRole() === 'pemdes') ? '../admin/distribusi_detail.php' : '../petugas/detail.php'; ?>?id=<?php echo $dist['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Create Modal -->
    <div id="createModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('createModal').style.display='none'">&times;</span>
            <h2>Buat Jadwal Distribusi</h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="action" value="create">
                <div class="form-group">
                    <label>Dusun</label>
                    <select name="dusun_id" id="dusun_id" required>
                        <option value="">Pilih Dusun</option>
                        <?php foreach ($dusun_list as $dusun): ?>
                        <option value="<?php echo $dusun['id']; ?>"><?php echo htmlspecialchars($dusun['nama_desa']); ?> - <?php echo htmlspecialchars($dusun['nama_dusun']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Tanggal Jadwal</label>
                    <input type="date" name="tanggal_jadwal" required min="<?php echo date('Y-m-d'); ?>">
                </div>
                <?php if (isAdmin() || getUserRole() === 'pemdes'): ?>
                <div class="form-group">
                    <label>Petugas</label>
                    <select name="petugas_id">
                        <option value="">Pilih Petugas</option>
                        <?php foreach ($petugas_list as $petugas): ?>
                        <option value="<?php echo $petugas['id']; ?>"><?php echo htmlspecialchars($petugas['nama_lengkap']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="form-group">
                    <label>Volume (Liter)</label>
                    <input type="number" name="volume_liter" min="0" value="5000">
                </div>
                <div class="form-group">
                    <label>Catatan</label>
                    <textarea name="catatan" rows="3"></textarea>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Simpan</button>
            </form>
        </div>
    </div>

    <script src="../assets/js/main.js"></script>
    <script>
    function quickSchedule(dusunId, dusunName) {
        document.getElementById('createModal').style.display = 'block';
        document.getElementById('dusun_id').value = dusunId;
        document.getElementById('tanggal_jadwal').value = '<?php echo date('Y-m-d'); ?>';
    }
    
    window.onclick = function(event) {
        if (event.target == document.getElementById('createModal')) {
            document.getElementById('createModal').style.display = 'none';
        }
    }
    </script>
    <style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        overflow-y: auto;
    }
    
    .modal-content {
        background: white;
        margin: 5% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 600px;
    }
    
    .close {
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        color: #999;
    }
    </style>
</body>
</html>

