# Panduan Instalasi SumberAI

## Persyaratan

- PHP 7.4 atau lebih tinggi
- MySQL/MariaDB 5.7 atau lebih tinggi
- Web server (Apache/Nginx)
- Mod_rewrite enabled (untuk Apache)

## Langkah Instalasi

### 1. Upload File

Upload semua file ke direktori hosting Anda, misalnya:
- `public_html/`
- `www/`
- `htdocs/`

### 2. Buat Database

1. Login ke cPanel atau phpMyAdmin
2. Buat database baru dengan nama `sumberai`
3. Import file `database.sql` ke database tersebut

### 3. Konfigurasi Database

Edit file `config/database.php`:

```php
define('DB_HOST', 'localhost');  // Ganti jika perlu
define('DB_USER', 'username_db'); // Ganti dengan username database Anda
define('DB_PASS', 'password_db'); // Ganti dengan password database Anda
define('DB_NAME', 'sumberai');    // Nama database
```

### 4. Konfigurasi URL

Edit file `config/config.php`:

```php
define('APP_URL', 'http://yourdomain.com/sumberaifix'); // Ganti dengan URL Anda
```

### 5. Set Permissions

Pastikan folder berikut dapat ditulis:
- `uploads/` (jika ada)

```bash
chmod 755 uploads/
```

### 6. Akses Aplikasi

Buka browser dan akses:
```
http://yourdomain.com/sumberaifix
```

## Default Login

- **Username:** admin
- **Password:** admin123

**PENTING:** Segera ubah password admin setelah login pertama kali!

## Troubleshooting

### Error: Database connection failed
- Pastikan kredensial database di `config/database.php` benar
- Pastikan database sudah dibuat dan di-import

### Error: 404 Not Found
- Pastikan mod_rewrite enabled
- Pastikan file `.htaccess` ada
- Cek konfigurasi `APP_URL` di `config/config.php`

### Error: Permission denied
- Pastikan folder `uploads/` memiliki permission 755 atau 777

## Support

Jika mengalami masalah, periksa:
1. Error log di hosting
2. PHP error log
3. Database connection

