<?php
// routes/web.php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DesaController;
use App\Http\Controllers\PrediksiController;
use App\Http\Controllers\LaporanController;
use App\Http\Controllers\TangkiController;

// Landing Page
Route::get('/', function () {
    return view('landing');
})->name('landing');

// Authentication
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
    Route::post('/register', [AuthController::class, 'register']);
});

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Dashboard (All authenticated users)
Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/prediksi', [PrediksiController::class, 'index'])->name('prediksi.index');
    Route::get('/peta', [PrediksiController::class, 'peta'])->name('peta');
    Route::get('/laporan', [LaporanController::class, 'index'])->name('laporan.index');
    Route::post('/laporan', [LaporanController::class, 'store'])->name('laporan.store');
});
// Prediksi routes
Route::middleware('auth')->group(function () {
    Route::get('/prediksi', [PrediksiController::class, 'index'])->name('prediksi.index');
    Route::get('/prediksi/{id}', [PrediksiController::class, 'show'])->name('prediksi.show');
    Route::post('/prediksi/generate', [PrediksiController::class, 'generate'])->name('prediksi.generate');
    Route::post('/prediksi/generate-all', [PrediksiController::class, 'generateAll'])->name('prediksi.generate-all');
    Route::get('/prediksi/chart-data', [PrediksiController::class, 'chartData'])->name('prediksi.chart-data');
    Route::get('/peta', [PrediksiController::class, 'peta'])->name('peta');
    
    // Laporan routes
    Route::get('/laporan', [LaporanController::class, 'index'])->name('laporan.index');
    Route::post('/laporan', [LaporanController::class, 'store'])->name('laporan.store');
    Route::get('/laporan/{id}', [LaporanController::class, 'show'])->name('laporan.show');
    Route::post('/laporan/{id}/status', [LaporanController::class, 'updateStatus'])->name('laporan.update-status');
    Route::delete('/laporan/{id}', [LaporanController::class, 'destroy'])->name('laporan.destroy');
    Route::get('/desa/{desa}/dusun', [LaporanController::class, 'getDusun'])->name('laporan.get-dusun');
    
    // Notifikasi routes
    Route::get('/notifikasi', [NotifikasiController::class, 'index'])->name('notifikasi.index');
    Route::post('/notifikasi/{id}/read', [NotifikasiController::class, 'markAsRead'])->name('notifikasi.mark-read');
    Route::post('/notifikasi/read-all', [NotifikasiController::class, 'markAllAsRead'])->name('notifikasi.mark-all-read');
    Route::delete('/notifikasi/{id}', [NotifikasiController::class, 'destroy'])->name('notifikasi.destroy');
    Route::get('/notifikasi/unread-count', [NotifikasiController::class, 'getUnreadCount'])->name('notifikasi.unread-count');
    Route::get('/notifikasi/latest', [NotifikasiController::class, 'getLatest'])->name('notifikasi.latest');
});

// Admin routes (tambahan)
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Desa management
    Route::get('/desa', [DesaController::class, 'index'])->name('desa.index');
    Route::post('/desa', [DesaController::class, 'store'])->name('desa.store');
    Route::get('/desa/{id}', [DesaController::class, 'show'])->name('desa.show');
    Route::put('/desa/{id}', [DesaController::class, 'update'])->name('desa.update');
    Route::delete('/desa/{id}', [DesaController::class, 'destroy'])->name('desa.destroy');
    
    Route::post('/dusun', [DesaController::class, 'storeDusun'])->name('dusun.store');
    Route::put('/dusun/{id}', [DesaController::class, 'updateDusun'])->name('dusun.update');
    Route::delete('/dusun/{id}', [DesaController::class, 'destroyDusun'])->name('dusun.destroy');
    
    // Tangki management
    Route::get('/tangki', [TangkiController::class, 'index'])->name('tangki.index');
    Route::post('/tangki', [TangkiController::class, 'store'])->name('tangki.store');
    Route::post('/tangki/{id}/status', [TangkiController::class, 'updateStatus'])->name('tangki.update-status');
    Route::post('/tangki/{id}/assign', [TangkiController::class, 'assignPetugas'])->name('tangki.assign');
    Route::delete('/tangki/{id}', [TangkiController::class, 'destroy'])->name('tangki.destroy');
    Route::post('/tangki/generate-ai', [TangkiController::class, 'generateAISchedule'])->name('tangki.generate-ai');
});

 
 
 
// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/users', [AdminController::class, 'users'])->name('users');
    Route::post('/users', [AdminController::class, 'createUser'])->name('users.create');
    Route::post('/users/{id}/reset-password', [AdminController::class, 'resetPassword'])->name('users.reset-password');
    Route::post('/users/{id}/update-username', [AdminController::class, 'updateUsername'])->name('users.update-username');
    Route::post('/users/{id}/toggle-status', [AdminController::class, 'toggleUserStatus'])->name('users.toggle-status');
    
    Route::get('/desa', [DesaController::class, 'index'])->name('desa.index');
    Route::post('/desa', [DesaController::class, 'store'])->name('desa.store');
    Route::put('/desa/{id}', [DesaController::class, 'update'])->name('desa.update');
    
    Route::get('/menu-icons', [AdminController::class, 'menuIcons'])->name('menu-icons');
    Route::post('/menu-icons/{id}', [AdminController::class, 'updateMenuIcon'])->name('menu-icons.update');
    
    Route::get('/tangki', [TangkiController::class, 'index'])->name('tangki.index');
    Route::post('/tangki', [TangkiController::class, 'store'])->name('tangki.store');
});
