<?php
// database/migrations/2025_01_01_000008_create_menu_icons_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('menu_icons', function (Blueprint $table) {
            $table->id();
            $table->string('nama_menu');
            $table->string('icon_class')->default('fa-solid fa-circle');
            $table->string('route_name');
            $table->enum('role_access', ['all', 'admin', 'warga', 'pemdes', 'petugas_tangki'])->default('all');
            $table->integer('urutan')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('menu_icons');
    }
};
