<?php
// database/migrations/2025_01_01_000006_create_tangki_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tangki', function (Blueprint $table) {
            $table->id();
            $table->foreignId('desa_id')->constrained()->onDelete('cascade');
            $table->foreignId('dusun_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('petugas_id')->nullable()->constrained('users')->onDelete('set null');
            $table->date('tanggal_pengiriman');
            $table->time('waktu_pengiriman')->nullable();
            $table->integer('volume_air')->default(0); // dalam liter
            $table->integer('prioritas')->default(0); // 1-10, 10 highest
            $table->enum('status', ['dijadwalkan', 'dalam_perjalanan', 'selesai', 'dibatalkan'])->default('dijadwalkan');
            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tangki');
    }
};
