<?php
// database/migrations/2025_01_01_000004_create_prediksi_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('prediksi', function (Blueprint $table) {
            $table->id();
            $table->foreignId('desa_id')->constrained()->onDelete('cascade');
            $table->foreignId('dusun_id')->nullable()->constrained()->onDelete('cascade');
            $table->date('tanggal_prediksi');
            $table->decimal('curah_hujan', 8, 2)->default(0); // mm
            $table->decimal('kelembapan_tanah', 5, 2)->default(0); // %
            $table->enum('tingkat_risiko', ['aman', 'waspada', 'kritis'])->default('aman');
            $table->integer('risiko_score')->default(0); // 0-100
            $table->text('rekomendasi')->nullable();
            $table->json('data_bmkg')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('prediksi');
    }
};
